(function() {
  //farmerswife.com , 6/03/2014 Rafa Dorado
  define(['jquery', 'underscore', 'Handlebars', 'Backbone', 'moment', 'models/todo/TodoModel', 'views/todo/TodoDetailView', 'views/todo/FormTodoView', 'PrecompiledTemplates'], function($, _, Handlebars, Backbone, Moment, TodoModel, TodoDetailView, FormTodoView) {
    var TodoListView;
    return TodoListView = class TodoListView extends Backbone.View {
      initialize(usr, todosCol) {
        this.usr = usr;
        this.todosCol = todosCol;
        this.todosCol.on('collectionTodosFilled', this.update_todos, this);
        return this.showingList = 'me';
      }

      events() {
        return {
          'tap #id-btn-panel': 'btnPanelClicked',
          'tap .btn-submenu-todolist': 'btnSubmenuClicked',
          'tap .ul-todolist > li': 'liTodoClicked',
          'tap #id-btn-add-todo': 'btnAddTodoClicked',
          'pageshow': 'setMenus'
        };
      }

      render() {
        var template;
        template = Handlebars.templates['TodoListView'];
        this.$el.html(template({
          myTodosToday: this.todosCol.byType('forMe').byTime('today').toJSON(),
          myTodosFuture: this.todosCol.byType('forMe').byTime('future').toJSON(),
          myTodosPast: this.todosCol.byType('forMe').byTime('past').toJSON(),
          othersTodosToday: this.todosCol.byType('forAnotherByMe').byTime('today').toJSON(),
          othersTodosFuture: this.todosCol.byType('forAnotherByMe').byTime('future').toJSON(),
          othersTodosPast: this.todosCol.byType('forAnotherByMe').byTime('past').toJSON()
        }));
        this.addSidePanel();
        return this.$el.attr('id', 'id-TodoListView');
      }

      addSidePanel() {
        var MenuView;
        if (!MenuView) {
          MenuView = require("views/menu/MenuView");
        }
        this.panel = new MenuView(this.usr);
        this.panel.render();
        return this.$el.append(this.panel.el);
      }

      setMenus(event) {
        if (this.showingList === 'me') {
          $('#id-submenu-todolist-me').addClass('ui-btn-active');
          $('.subTodoListView').hide();
          return $('#id-divtodoMe').show();
        } else if (this.showingList === 'others') {
          $('#id-submenu-todolist-others').addClass('ui-btn-active');
          $('.subTodoListView').hide();
          return $('#id-divtodoOthers').show();
        } else {
          $('#id-submenu-todolist-recent').addClass('ui-btn-active');
          $('.subTimeReportView').hide();
          return $('#id-divtodoRecent').show();
        }
      }

      btnSubmenuClicked(event) {
        var btn, id;
        event.preventDefault();
        event.stopPropagation();
        btn = $(event.currentTarget);
        id = btn.attr('data-target');
        if (id === '#id-divtodoMe') {
          this.showingList = 'me';
        } else if (id === '#id-divtodoOthers') {
          this.showingList = 'others';
        } else {
          this.showingList = 'recent';
        }
        this.$el.find('.subTodoListView').hide();
        return $(id).show();
      }

      btnPanelClicked(event) {
        event.preventDefault();
        event.stopPropagation();
        return this.panel.btnPanelClicked(event);
      }

      update_todos() {
        var ul;
        ul = this.$el.find('#id-ul-todolist-me');
        this.__update_list(this.todosCol.byType('forMe'), ul);
        ul = this.$el.find('#id-ul-todolist-others');
        this.__update_list(this.todosCol.byType('forAnotherByMe'), ul);
        ul = this.$el.find('#id-ul-todolist-recent');
        return this.__update_recent(ul);
      }

      __update_list(col, ul) {
        var future, past, today;
        ul.empty();
        //PAST
        past = col.byTime('past');
        if (past.models.length > 0) {
          ul.append('<h1>Overdue</h1>');
          past.each((todo) => {
            return ul.append(this.__get_todo_li(todo, true));
          });
        }
        //TODAY
        today = col.byTime('today');
        if (today.models.length > 0) {
          ul.append('<h1>Today</h1>');
          today.each((todo) => {
            return ul.append(this.__get_todo_li(todo));
          });
        }
        //FUTURE
        future = col.byTime('future');
        if (future.models.length > 0) {
          ul.append('<h1>Upcoming</h1>');
          future.each((todo) => {
            return ul.append(this.__get_todo_li(todo));
          });
        }
        return ul.listview('refresh');
      }

      __update_recent(ul) {
        ul.empty();
        this.todosCol.each((todo) => {
          if (todo.get('recent') && todo.get('todoID') !== 'new') {
            return ul.append(this.__get_todo_li(todo));
          }
        });
        return ul.listview('refresh');
      }

      __get_todo_li(todo, past) {
        var cssClassPast, date, html, priority, ref, ref1;
        if (past) {
          cssClassPast = 'past-todo';
        } else {
          cssClassPast = '';
        }
        html = '<li data-todoid="' + todo.get("todoID") + '"><span class="arrow-right fwi-arrow-right"/>';
        if (todo.get('priority')) {
          priority = '<span class="fwi-flag icon-todo-left" style="color: #d5891d !important;"/>';
        } else {
          priority = '';
        }
        if (todo.get('forDate')) {
          date = Handlebars.helpers.beautyDateForTodos(todo.get('forDate'));
        } else {
          date = Handlebars.helpers.beautyDateForTodos(todo.get('forDateAndTime'));
        }
        if (todo.get('recent')) {
          if (((ref = todo.get('done')) === 1 || ref === "1") || ((ref1 = todo.get('isDone')) === 1 || ref1 === "1")) {
            html += "<div class=\"stamp-box done\"/>";
          } else {
            html += "<div class=\"stamp-box not-done\"/>";
          }
        }
        html += `<div class=\"header\">${priority} ${todo.get('title')}</div>`;
        if (todo.get('alarmMinutesBefore')) {
          html += `<div class=\"subheader ${cssClassPast}\"><span class=\"fwi-alarm icon-todo-left\"/>${Handlebars.helpers.beautyDateAndTimeForTodos(todo.get('forDateAndTime'), todo.get('alarmMinutesBefore'))}</div>`;
        } else {
          html += `<div class=\"subheader ${cssClassPast}\"><span class=\"fwi-clock icon-todo-left\"/> ${date}</div>`;
        }
        if (todo.get('contactName')) {
          html += `<div class=\"subheader\"><span class=\"fwi-contact icon-todo-left\" /> ${todo.get('contactName')} &bull; ${todo.get('contactCompanyName')}</div>`;
        }
        if (todo.get('projectName')) {
          html += `<div class=\"subheader\"><span class=\"fwi-project icon-todo-left\"/> ${todo.get('projectName')}</div>`;
        }
        if (todo.get('addedToUserName')) {
          html += `<div class=\"subheader\"><span class=\"fwi-contact icon-todo-left\" style=\"color:#BA6639;\"/> For ${todo.get('addedToUserName')}</div>`;
        }
        if (todo.get('declined')) {
          html += "<br/><span class='fwi-cross-cancel' style='color:red;'>Declined</span> ";
        }
        return html += "</li>";
      }

      liTodoClicked(event) {
        var id, li, todo, view;
        event.stopPropagation();
        event.preventDefault();
        li = $(event.currentTarget);
        id = li.attr('data-todoid');
        todo = this.todosCol.findWhere({
          todoID: id
        });
        if (!TodoDetailView) {
          TodoDetailView = require('views/todo/TodoDetailView');
        }
        todo.get_todo_details(this.usr);
        view = new TodoDetailView(this.usr, todo);
        return $.mobile.jqmNavigator.pushView(view, {
          transition: 'none'
        });
      }

      __get_todos(type, time) {
        return this.todosCol.byType(type).byTime(time);
      }

      btnAddTodoClicked(event) {
        var todo;
        event.stopPropagation();
        event.preventDefault();
        todo = new TodoModel();
        this.todosCol.add(todo, {
          silent: true
        });
        todo.on('todoStructureChanged', _.bind(this.__go_to_todo_form_view, this, todo));
        return todo.get_todo_structure(this.usr);
      }

      __go_to_todo_form_view(todo) {
        var view;
        view = new FormTodoView(this.usr, todo, 'add');
        return $.mobile.jqmNavigator.pushView(view, {
          transition: 'none'
        });
      }

    };
  });

}).call(this);
